TITLE 								         { exa052.pde }
   'Positive and Negative Point Charges'	
SELECT
   spectral_colors				
DEFINITIONS                                     		
   Lx=1     Ly=1    d0=Ly/2     r0=8e-2     q=1          	
   eps0=8.85e-12     c=1/(4*pi*eps0)
   U= -q*c/sqrt(x^2+(y+d0)^2)+ q*c/sqrt(x^2+(y-d0)^2)	{ Signs: -, + }
   Ex=-dx(U)     Ey=-dy(U)                  		{ Field components }
   E=-grad(U)     Em=magnitude(E)                      			
   E_angle=sign(Ey)*arccos(Ex/Em)/pi*180 	{ Degrees }
BOUNDARIES
region 'domain'
   start(-Lx,-Ly)  line to (Lx,-Ly) to (Lx,Ly)  to (-Lx,Ly) close
   start(r0,-d0) arc( center=0,-d0) angle=360	{ Exclude circle }
   start(r0,d0) arc( center=0,d0) angle=360	{ Exclude circle }
PLOTS
   contour( U)   contour( Ex)   contour( Ey)	
   contour( abs(Ex)) log	   contour( abs(Ey)) log
   contour( Em) log   vector( E/Em)	  contour( E_angle)
END

